﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Reflection;
using System.Web.Script.Serialization;
using System.Globalization;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class AHOBPRGenericManager : AHOBPRBaseBO 
    {
        private AHOBPRShared _sharedManager = new AHOBPRShared();

        #region Data Access Log Update
        /// <summary>
        ///Save Data Access Log
        /// </summary>
        /// <param name="searchCriteria"></param>
        /// <returns></returns>
        public bool SaveDataAccessLog(string userId, string page, string userAgent)
        {
            return SaveDataAccessLog(userId, page, userAgent, 1);
        }

        /// <summary>
        /// Save Data Access Log with retry
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="page"></param>
        /// <param name="userAgent"></param>
        /// <param name="tryCount"></param>
        /// <returns></returns>
        private bool SaveDataAccessLog(string userId, string page, string userAgent, int tryCount)
        {
            bool result = false;
            if (tryCount >= 10)
            {
                _sharedManager.LogErrorMessage("Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name,
                    "Unable to save data access log after 10 tries: {userId:" + userId + "}, {page:" + page + "},{userAgent:" + userAgent + "}");

                return result;
            }
            if (tryCount > 1)
            {
                _sharedManager.LogErrorMessage("Retry", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name,
                    "retry #" + tryCount.ToString() + ": {userId:" + userId + "}");
            }
            if (string.IsNullOrEmpty(userId) && string.IsNullOrEmpty(page) && string.IsNullOrEmpty(userAgent))
            {
                return result;
            }
            try
            {
                Dictionary<String, Object> param = new Dictionary<string, object>();
                param.Add("@userId", userId);
                param.Add("@userAgent", userAgent);
                param.Add("@pageName", page);
                DbUtil.ExecuteSProc("AHOBPR.SP_InsertDataAccessLog", param);
                result = true;
                return result;
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "; Object: {userID:" + userId + "}, {page:" + page + "}; " + ex.StackTrace);
                result = SaveDataAccessLog(userId, page, userAgent, tryCount + 1);
                return result;
            }
        }

        #endregion
        
        #region Get deploymentLocation base names by search Criteria
        /// <summary>
        ///  Get deploymentLocation base names by search Criteria
        /// </summary>
        /// <param name="searchCriteria"></param>
        /// <returns></returns>
        public BprDeploymentBaseName[] GetDeploymentBaseNames(string searchCriteria)
        {
            if (string.IsNullOrEmpty(searchCriteria))
            {
                return (new List<BprDeploymentBaseName>()).ToArray();
            }
            else
            {
                List<STD_DEPLOYMENT_LOCATION> locations = new List<STD_DEPLOYMENT_LOCATION>();
                string[] searches = searchCriteria.Split(' ');
                using (_dbAhobpr = GetDataContext())
                {
                    if (searches.Length == 1)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();

                    }
                    else if (searches.Length == 2)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 3)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                         && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 4)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                        && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                        && (e.NAMES.Contains(searches[3]) || e.COUNTRY.Contains(searches[3]) || e.BASE.Contains(searches[3])
                                            || e.PROVINCE.Contains(searches[3]) || e.OTHER_NAMES.Contains(searches[3]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 5)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                         && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                         && (e.NAMES.Contains(searches[3]) || e.COUNTRY.Contains(searches[3]) || e.BASE.Contains(searches[3])
                                            || e.PROVINCE.Contains(searches[3]) || e.OTHER_NAMES.Contains(searches[3]))
                                         && (e.NAMES.Contains(searches[4]) || e.COUNTRY.Contains(searches[4]) || e.BASE.Contains(searches[4])
                                            || e.PROVINCE.Contains(searches[4]) || e.OTHER_NAMES.Contains(searches[4]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                }

                List<BprDeploymentBaseName> bprBaseNames = new List<BprDeploymentBaseName>();
                foreach (STD_DEPLOYMENT_LOCATION location in locations)
                {
                    BprDeploymentBaseName bprBase = new BprDeploymentBaseName();
                    bprBase.@base = location.BASE + (string.IsNullOrEmpty(location.NAMES) || location.NAMES.ToLower() == "none" ? "" : " (" + location.NAMES + ")");
                    bprBaseNames.Add(bprBase);
                }

                return bprBaseNames.ToArray();
            }
        }

        public int GetStdServiceOccupationId(String searchCriteria)
        {
            searchCriteria = searchCriteria.ToLower();
            int occupationId = -1;
            using (_dbAhobpr = GetDataContext())
            {
                List<STD_SERVICE_OCCUPATION> results = (from o in _dbAhobpr.STD_SERVICE_OCCUPATIONs
                                                        where o.SERVICE_OCCUPATION_CODE.ToLower() == searchCriteria
                                                        select o).ToList();
                if (results.Count == 0)
                {
                    results = (from o in _dbAhobpr.STD_SERVICE_OCCUPATIONs
                               where o.SERVICE_TITLE.ToLower() == searchCriteria
                               select o).ToList();
                }

                if (results.Count == 0)
                {
                    occupationId = AddNewServiceOccupation(searchCriteria);
                }
                else
                {
                    occupationId = results[0].STD_SERVICE_OCCUPATION_ID;
                }
            }

            return occupationId;
        }

        public int GetStdDischargeCharacterId(String searchCriteria)
        {
            searchCriteria = searchCriteria.ToLower();
            int dischargeId = -1;
            using (_dbAhobpr = GetDataContext())
            {
                List<STD_DISCHARGE_CHARACTER> results = (from o in _dbAhobpr.STD_DISCHARGE_CHARACTERs
                                                        where o.DISCHARGE_CHARACTER_CODE.ToLower() == searchCriteria
                                                        select o).ToList();
                if (results.Count == 0)
                {
                    dischargeId = AddNewDischargeCharacter(searchCriteria);
                }
                else
                {
                    dischargeId = results[0].STD_DISCHARGE_CHARACTER_ID;
                }
            }

            return dischargeId;
        }

        #endregion

        #region Inserts

        public int AddNewServiceOccupation(string serviceOccupationCode)
        {
            int result;
            using (_dbAhobpr = GetDataContext())
            {
                _dbAhobpr.DeferredLoadingEnabled = false;

                STD_SERVICE_OCCUPATION serviceOccupation = new STD_SERVICE_OCCUPATION();
                serviceOccupation.CREATED = DateTime.Now;
                serviceOccupation.CREATEDBY = "AHOBPR DBA";
                serviceOccupation.UPDATED = DateTime.Now;
                serviceOccupation.UPDATEDBY = "AHOBPR DBA";
                serviceOccupation.SERVICE_TITLE = serviceOccupationCode;
                serviceOccupation.SERVICE_OCCUPATION_CODE = serviceOccupationCode;
                
                _dbAhobpr.STD_SERVICE_OCCUPATIONs.InsertOnSubmit(serviceOccupation);

                try
                {
                    _dbAhobpr.SubmitChanges(ConflictMode.ContinueOnConflict);
                    result = serviceOccupation.STD_SERVICE_OCCUPATION_ID;
                }
                catch (System.Data.SqlClient.SqlException ex)
                {
                    _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                    result = -1;
                }
                catch (ChangeConflictException e)
                {
                    _dbAhobpr.ChangeConflicts.ResolveAll(RefreshMode.KeepCurrentValues);

                    try
                    {
                        _dbAhobpr.SubmitChanges(ConflictMode.FailOnFirstConflict);
                        result = serviceOccupation.STD_SERVICE_OCCUPATION_ID;
                    }
                    catch (Exception ex)
                    {
                        _sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                        result = -1;
                    }
                }
                catch
                {
                    result = -1;
                }
            }
            return result;
        }

        public int AddNewDischargeCharacter(string dischargeChar)
        {
            int result;
            using (_dbAhobpr = GetDataContext())
            {
                _dbAhobpr.DeferredLoadingEnabled = false;

                STD_DISCHARGE_CHARACTER dischargeCharacter = new STD_DISCHARGE_CHARACTER();
                dischargeCharacter.CREATED = DateTime.Now;
                dischargeCharacter.CREATEDBY = "AHOBPR DBA";
                dischargeCharacter.UPDATED = DateTime.Now;
                dischargeCharacter.UPDATEDBY = "AHOBPR DBA";
                dischargeCharacter.DISCHARGE_CHARACTER = dischargeChar;
                dischargeCharacter.DISCHARGE_CHARACTER_CODE = dischargeChar;

                _dbAhobpr.STD_DISCHARGE_CHARACTERs.InsertOnSubmit(dischargeCharacter);

                try
                {
                    _dbAhobpr.SubmitChanges(ConflictMode.ContinueOnConflict);
                    result = dischargeCharacter.STD_DISCHARGE_CHARACTER_ID;
                }
                catch (System.Data.SqlClient.SqlException ex)
                {
                    _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                    result = -1;
                }
                catch (ChangeConflictException e)
                {
                    _dbAhobpr.ChangeConflicts.ResolveAll(RefreshMode.KeepCurrentValues);

                    try
                    {
                        _dbAhobpr.SubmitChanges(ConflictMode.FailOnFirstConflict);
                        result = dischargeCharacter.STD_DISCHARGE_CHARACTER_ID;
                    }
                    catch (Exception ex)
                    {
                        _sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                        result = -1;
                    }
                }
                catch
                {
                    result = -1;
                }
            }
            return result;
        }

        #endregion

        #region Deletes
        
        /// <summary>
        /// Delete a registrant from database by registrant ID
        /// </summary>
        /// <param name="registrantid"></param>
        /// <returns></returns>
        public bool DeteleRegistrant(int registrantid)
        {
            bool result = true;
            using (_dbAhobpr = GetDataContext())
            {
                _dbAhobpr.SP_DeleteOneRegistrant(registrantid);
            }
            return result;
        }


        /// <summary>
        /// Delete CPRS log entry for a registrant
        /// </summary>
        /// <param name="registrantid"></param>
        /// <returns></returns>
        public bool DeteleCprsLog(int registrantid)
        {
            bool result = true;
            using (_dbAhobpr = GetDataContext())
            {
                _dbAhobpr.SP_DeleteCprsLog(registrantid);
            }
            return result;
        }

        #endregion

        #region Reset database

        public bool ResetDatabase()
        {
            bool result = true;
            using (_dbAhobpr = GetDataContext())
            {
                _dbAhobpr.SP_ResetDatabase();
            }
            return result;
        }

        public bool ClearProcessMetrics()
        {
            bool result = true;
            using (_dbAhobpr = GetDataContext())
            {
                _dbAhobpr.sp_ClearProcessMetrics();
            }
            return result;
        }
        #endregion

        #region Save Interface Log
        /// <summary>
        /// Save interface log
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public bool SaveInterfaceLog(string userId, string value)
        {
            bool result = false;
            if (string.IsNullOrEmpty(userId) && string.IsNullOrEmpty(value))
            {
                return result;
            }
            else
            {
                try
                {
                    Dictionary<String, Object> param = new Dictionary<string, object>();
                    param.Add("@userId", userId);
                    param.Add("@interfaceName", "PDF Utility");
                    param.Add("@param", userId);
                    param.Add("@returnValue", value);
                    param.Add("@createdBy", "RESTful Service");
                    DbUtil.ExecuteSProc("AHOBPR.SP_InsertInterfaceLog", param);
                    result = true;
                }
                catch (Exception ex)
                {
                    _sharedManager.LogErrorMessage("Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + ex.StackTrace);
                    result = false;
                }
                return result;
            }
        }

        #endregion

        #region Get user role
        public string GetUserRole(string userName)
        {
            string role = string.Empty;
            BusinessManager.RegistriesGlobal.UserRoleAll = null;
            BusinessManager.UserAccountManager manager = new UserAccountManager(userName, "AHOBPR");
            role = manager.RoleName;
            return role;
        }
        #endregion


        #region Get application notification
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public string GetApplicationNotification()
        {
            string notification = string.Empty;
            BusinessManager.RegistriesCommonManager manager = new RegistriesCommonManager();
            APPLICATION_STATUS appStatus = manager.GetApplicationStatus("AHOBPR");
            if (appStatus != null)
            {
                if (appStatus.PROCESS_FLAG == 1)
                {
                    notification = appStatus.MESSAGE;
                }
            }
            return notification;
        }
        #endregion
    }
}
